package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class KafkaConnectorArgs private(
  config: Output[scala.Predef.Map[String, String]],
  connectorName: Output[String],
  project: Output[String],
  serviceName: Output[String]
) derives ArgsEncoder

object KafkaConnectorArgs:
  def apply(
    config: Input[scala.Predef.Map[String, Input[String]]],
    connectorName: Input[String],
    project: Input[String],
    serviceName: Input[String]
  )(using Context): KafkaConnectorArgs =
    new KafkaConnectorArgs(
      config = config.asOutput(isSecret = false),
      connectorName = connectorName.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false)
    )
