package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class KafkaSchema private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  compatibilityLevel: Output[Option[String]],
  project: Output[String],
  schema: Output[String],
  schemaType: Output[Option[String]],
  serviceName: Output[String],
  subjectName: Output[String],
  version: Output[Int]
) extends CustomResource derives ResourceDecoder

object KafkaSchema:
  given outputOps: {} with
    extension(output: Output[KafkaSchema])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def compatibilityLevel: Output[Option[String]] = output.flatMap(_.compatibilityLevel)
      def project: Output[String] = output.flatMap(_.project)
      def schema: Output[String] = output.flatMap(_.schema)
      def schemaType: Output[Option[String]] = output.flatMap(_.schemaType)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def subjectName: Output[String] = output.flatMap(_.subjectName)
      def version: Output[Int] = output.flatMap(_.version)

def kafkaSchema(using ctx: Context)(
  name: NonEmptyString,
  args: KafkaSchemaArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[KafkaSchema] = 
  ctx.registerResource[KafkaSchema, KafkaSchemaArgs]("aiven:index/kafkaSchema:KafkaSchema", name, args, opts)

