package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class KafkaSchemaArgs private(
  compatibilityLevel: Output[Option[String]],
  project: Output[String],
  schema: Output[String],
  schemaType: Output[Option[String]],
  serviceName: Output[String],
  subjectName: Output[String]
) derives ArgsEncoder

object KafkaSchemaArgs:
  def apply(
    compatibilityLevel: Input.Optional[String] = None,
    project: Input[String],
    schema: Input[String],
    schemaType: Input.Optional[String] = None,
    serviceName: Input[String],
    subjectName: Input[String]
  )(using Context): KafkaSchemaArgs =
    new KafkaSchemaArgs(
      compatibilityLevel = compatibilityLevel.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      schema = schema.asOutput(isSecret = false),
      schemaType = schemaType.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      subjectName = subjectName.asOutput(isSecret = false)
    )
