package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class KafkaSchemaConfiguration private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  compatibilityLevel: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String]
) extends CustomResource derives ResourceDecoder

object KafkaSchemaConfiguration:
  given outputOps: {} with
    extension(output: Output[KafkaSchemaConfiguration])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def compatibilityLevel: Output[Option[String]] = output.flatMap(_.compatibilityLevel)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)

def kafkaSchemaConfiguration(using ctx: Context)(
  name: NonEmptyString,
  args: KafkaSchemaConfigurationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[KafkaSchemaConfiguration] = 
  ctx.registerResource[KafkaSchemaConfiguration, KafkaSchemaConfigurationArgs]("aiven:index/kafkaSchemaConfiguration:KafkaSchemaConfiguration", name, args, opts)

