package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class KafkaSchemaConfigurationArgs private(
  compatibilityLevel: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String]
) derives ArgsEncoder

object KafkaSchemaConfigurationArgs:
  def apply(
    compatibilityLevel: Input.Optional[String] = None,
    project: Input[String],
    serviceName: Input[String]
  )(using Context): KafkaSchemaConfigurationArgs =
    new KafkaSchemaConfigurationArgs(
      compatibilityLevel = compatibilityLevel.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false)
    )
