package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class KafkaSchemaRegistryAcl private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  aclId: Output[String],
  permission: Output[String],
  project: Output[String],
  resource: Output[String],
  serviceName: Output[String],
  username: Output[String]
) extends CustomResource derives ResourceDecoder

object KafkaSchemaRegistryAcl:
  given outputOps: {} with
    extension(output: Output[KafkaSchemaRegistryAcl])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def aclId: Output[String] = output.flatMap(_.aclId)
      def permission: Output[String] = output.flatMap(_.permission)
      def project: Output[String] = output.flatMap(_.project)
      def resource: Output[String] = output.flatMap(_.resource)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def username: Output[String] = output.flatMap(_.username)

def kafkaSchemaRegistryAcl(using ctx: Context)(
  name: NonEmptyString,
  args: KafkaSchemaRegistryAclArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[KafkaSchemaRegistryAcl] = 
  ctx.registerResource[KafkaSchemaRegistryAcl, KafkaSchemaRegistryAclArgs]("aiven:index/kafkaSchemaRegistryAcl:KafkaSchemaRegistryAcl", name, args, opts)

