package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class KafkaSchemaRegistryAclArgs private(
  permission: Output[String],
  project: Output[String],
  resource: Output[String],
  serviceName: Output[String],
  username: Output[String]
) derives ArgsEncoder

object KafkaSchemaRegistryAclArgs:
  def apply(
    permission: Input[String],
    project: Input[String],
    resource: Input[String],
    serviceName: Input[String],
    username: Input[String]
  )(using Context): KafkaSchemaRegistryAclArgs =
    new KafkaSchemaRegistryAclArgs(
      permission = permission.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      resource = resource.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      username = username.asOutput(isSecret = false)
    )
