package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class KafkaTopic private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  config: Output[Option[besom.api.aiven.outputs.KafkaTopicConfig]],
  partitions: Output[Int],
  project: Output[String],
  replication: Output[Int],
  serviceName: Output[String],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.KafkaTopicTag]]],
  terminationProtection: Output[Option[Boolean]],
  topicName: Output[String]
) extends CustomResource derives ResourceDecoder

object KafkaTopic:
  given outputOps: {} with
    extension(output: Output[KafkaTopic])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def config: Output[Option[besom.api.aiven.outputs.KafkaTopicConfig]] = output.flatMap(_.config)
      def partitions: Output[Int] = output.flatMap(_.partitions)
      def project: Output[String] = output.flatMap(_.project)
      def replication: Output[Int] = output.flatMap(_.replication)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.KafkaTopicTag]]] = output.flatMap(_.tags)
      def terminationProtection: Output[Option[Boolean]] = output.flatMap(_.terminationProtection)
      def topicName: Output[String] = output.flatMap(_.topicName)

def kafkaTopic(using ctx: Context)(
  name: NonEmptyString,
  args: KafkaTopicArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[KafkaTopic] = 
  ctx.registerResource[KafkaTopic, KafkaTopicArgs]("aiven:index/kafkaTopic:KafkaTopic", name, args, opts)

