package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class KafkaTopicArgs private(
  config: Output[Option[besom.api.aiven.inputs.KafkaTopicConfigArgs]],
  partitions: Output[Int],
  project: Output[String],
  replication: Output[Int],
  serviceName: Output[String],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.KafkaTopicTagArgs]]],
  terminationProtection: Output[Option[Boolean]],
  topicName: Output[String]
) derives ArgsEncoder

object KafkaTopicArgs:
  def apply(
    config: Input.Optional[besom.api.aiven.inputs.KafkaTopicConfigArgs] = None,
    partitions: Input[Int],
    project: Input[String],
    replication: Input[Int],
    serviceName: Input[String],
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.KafkaTopicTagArgs]]] = None,
    terminationProtection: Input.Optional[Boolean] = None,
    topicName: Input[String]
  )(using Context): KafkaTopicArgs =
    new KafkaTopicArgs(
      config = config.asOptionOutput(isSecret = false),
      partitions = partitions.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      replication = replication.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false),
      topicName = topicName.asOutput(isSecret = false)
    )
