package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class KafkaUser private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accessCert: Output[String],
  accessKey: Output[String],
  password: Output[String],
  project: Output[String],
  serviceName: Output[String],
  `type`: Output[String],
  username: Output[String]
) extends CustomResource derives ResourceDecoder

object KafkaUser:
  given outputOps: {} with
    extension(output: Output[KafkaUser])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accessCert: Output[String] = output.flatMap(_.accessCert)
      def accessKey: Output[String] = output.flatMap(_.accessKey)
      def password: Output[String] = output.flatMap(_.password)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def username: Output[String] = output.flatMap(_.username)

def kafkaUser(using ctx: Context)(
  name: NonEmptyString,
  args: KafkaUserArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[KafkaUser] = 
  ctx.registerResource[KafkaUser, KafkaUserArgs]("aiven:index/kafkaUser:KafkaUser", name, args, opts)

