package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class M3AggregatorArgs private(
  additionalDiskSpace: Output[Option[String]],
  cloudName: Output[Option[String]],
  diskSpace: Output[Option[String]],
  m3aggregatorUserConfig: Output[Option[besom.api.aiven.inputs.M3AggregatorM3aggregatorUserConfigArgs]],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.M3AggregatorServiceIntegrationArgs]]],
  serviceName: Output[String],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.M3AggregatorTagArgs]]],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object M3AggregatorArgs:
  def apply(
    additionalDiskSpace: Input.Optional[String] = None,
    cloudName: Input.Optional[String] = None,
    diskSpace: Input.Optional[String] = None,
    m3aggregatorUserConfig: Input.Optional[besom.api.aiven.inputs.M3AggregatorM3aggregatorUserConfigArgs] = None,
    maintenanceWindowDow: Input.Optional[String] = None,
    maintenanceWindowTime: Input.Optional[String] = None,
    plan: Input[String],
    project: Input[String],
    projectVpcId: Input.Optional[String] = None,
    serviceIntegrations: Input.Optional[List[Input[besom.api.aiven.inputs.M3AggregatorServiceIntegrationArgs]]] = None,
    serviceName: Input[String],
    staticIps: Input.Optional[List[Input[String]]] = None,
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.M3AggregatorTagArgs]]] = None,
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): M3AggregatorArgs =
    new M3AggregatorArgs(
      additionalDiskSpace = additionalDiskSpace.asOptionOutput(isSecret = false),
      cloudName = cloudName.asOptionOutput(isSecret = false),
      diskSpace = diskSpace.asOptionOutput(isSecret = false),
      m3aggregatorUserConfig = m3aggregatorUserConfig.asOptionOutput(isSecret = false),
      maintenanceWindowDow = maintenanceWindowDow.asOptionOutput(isSecret = false),
      maintenanceWindowTime = maintenanceWindowTime.asOptionOutput(isSecret = false),
      plan = plan.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      projectVpcId = projectVpcId.asOptionOutput(isSecret = false),
      serviceIntegrations = serviceIntegrations.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
