package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class M3dbUser private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  password: Output[String],
  project: Output[String],
  serviceName: Output[String],
  `type`: Output[String],
  username: Output[String]
) extends CustomResource derives ResourceDecoder

object M3dbUser:
  given outputOps: {} with
    extension(output: Output[M3dbUser])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def password: Output[String] = output.flatMap(_.password)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def username: Output[String] = output.flatMap(_.username)

def m3dbUser(using ctx: Context)(
  name: NonEmptyString,
  args: M3dbUserArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[M3dbUser] = 
  ctx.registerResource[M3dbUser, M3dbUserArgs]("aiven:index/m3dbUser:M3dbUser", name, args, opts)

