package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class MirrorMakerReplicationFlow private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  emitHeartbeatsEnabled: Output[Option[Boolean]],
  enable: Output[Boolean],
  offsetSyncsTopicLocation: Output[Option[String]],
  project: Output[String],
  replicationPolicyClass: Output[Option[String]],
  serviceName: Output[String],
  sourceCluster: Output[String],
  syncGroupOffsetsEnabled: Output[Option[Boolean]],
  syncGroupOffsetsIntervalSeconds: Output[Option[Int]],
  targetCluster: Output[String],
  topics: Output[Option[scala.collection.immutable.List[String]]],
  topicsBlacklists: Output[Option[scala.collection.immutable.List[String]]]
) extends CustomResource derives ResourceDecoder

object MirrorMakerReplicationFlow:
  given outputOps: {} with
    extension(output: Output[MirrorMakerReplicationFlow])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def emitHeartbeatsEnabled: Output[Option[Boolean]] = output.flatMap(_.emitHeartbeatsEnabled)
      def enable: Output[Boolean] = output.flatMap(_.enable)
      def offsetSyncsTopicLocation: Output[Option[String]] = output.flatMap(_.offsetSyncsTopicLocation)
      def project: Output[String] = output.flatMap(_.project)
      def replicationPolicyClass: Output[Option[String]] = output.flatMap(_.replicationPolicyClass)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def sourceCluster: Output[String] = output.flatMap(_.sourceCluster)
      def syncGroupOffsetsEnabled: Output[Option[Boolean]] = output.flatMap(_.syncGroupOffsetsEnabled)
      def syncGroupOffsetsIntervalSeconds: Output[Option[Int]] = output.flatMap(_.syncGroupOffsetsIntervalSeconds)
      def targetCluster: Output[String] = output.flatMap(_.targetCluster)
      def topics: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.topics)
      def topicsBlacklists: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.topicsBlacklists)

def mirrorMakerReplicationFlow(using ctx: Context)(
  name: NonEmptyString,
  args: MirrorMakerReplicationFlowArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[MirrorMakerReplicationFlow] = 
  ctx.registerResource[MirrorMakerReplicationFlow, MirrorMakerReplicationFlowArgs]("aiven:index/mirrorMakerReplicationFlow:MirrorMakerReplicationFlow", name, args, opts)

