package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class MirrorMakerReplicationFlowArgs private(
  emitHeartbeatsEnabled: Output[Option[Boolean]],
  enable: Output[Boolean],
  offsetSyncsTopicLocation: Output[Option[String]],
  project: Output[String],
  replicationPolicyClass: Output[Option[String]],
  serviceName: Output[String],
  sourceCluster: Output[String],
  syncGroupOffsetsEnabled: Output[Option[Boolean]],
  syncGroupOffsetsIntervalSeconds: Output[Option[Int]],
  targetCluster: Output[String],
  topics: Output[Option[scala.collection.immutable.List[String]]],
  topicsBlacklists: Output[Option[scala.collection.immutable.List[String]]]
) derives ArgsEncoder

object MirrorMakerReplicationFlowArgs:
  def apply(
    emitHeartbeatsEnabled: Input.Optional[Boolean] = None,
    enable: Input[Boolean],
    offsetSyncsTopicLocation: Input.Optional[String] = None,
    project: Input[String],
    replicationPolicyClass: Input.Optional[String] = None,
    serviceName: Input[String],
    sourceCluster: Input[String],
    syncGroupOffsetsEnabled: Input.Optional[Boolean] = None,
    syncGroupOffsetsIntervalSeconds: Input.Optional[Int] = None,
    targetCluster: Input[String],
    topics: Input.Optional[List[Input[String]]] = None,
    topicsBlacklists: Input.Optional[List[Input[String]]] = None
  )(using Context): MirrorMakerReplicationFlowArgs =
    new MirrorMakerReplicationFlowArgs(
      emitHeartbeatsEnabled = emitHeartbeatsEnabled.asOptionOutput(isSecret = false),
      enable = enable.asOutput(isSecret = false),
      offsetSyncsTopicLocation = offsetSyncsTopicLocation.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      replicationPolicyClass = replicationPolicyClass.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      sourceCluster = sourceCluster.asOutput(isSecret = false),
      syncGroupOffsetsEnabled = syncGroupOffsetsEnabled.asOptionOutput(isSecret = false),
      syncGroupOffsetsIntervalSeconds = syncGroupOffsetsIntervalSeconds.asOptionOutput(isSecret = false),
      targetCluster = targetCluster.asOutput(isSecret = false),
      topics = topics.asOptionOutput(isSecret = false),
      topicsBlacklists = topicsBlacklists.asOptionOutput(isSecret = false)
    )
