package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class MySql private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  additionalDiskSpace: Output[Option[String]],
  cloudName: Output[Option[String]],
  components: Output[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlComponent]],
  diskSpace: Output[Option[String]],
  diskSpaceCap: Output[String],
  diskSpaceDefault: Output[String],
  diskSpaceStep: Output[String],
  diskSpaceUsed: Output[String],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  mysqlUserConfig: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfig]],
  mysqls: Output[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlMysql]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceHost: Output[String],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlServiceIntegration]]],
  serviceName: Output[String],
  servicePassword: Output[String],
  servicePort: Output[Int],
  serviceType: Output[String],
  serviceUri: Output[String],
  serviceUsername: Output[String],
  state: Output[String],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlTag]]],
  terminationProtection: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object MySql:
  given outputOps: {} with
    extension(output: Output[MySql])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def additionalDiskSpace: Output[Option[String]] = output.flatMap(_.additionalDiskSpace)
      def cloudName: Output[Option[String]] = output.flatMap(_.cloudName)
      def components: Output[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlComponent]] = output.flatMap(_.components)
      def diskSpace: Output[Option[String]] = output.flatMap(_.diskSpace)
      def diskSpaceCap: Output[String] = output.flatMap(_.diskSpaceCap)
      def diskSpaceDefault: Output[String] = output.flatMap(_.diskSpaceDefault)
      def diskSpaceStep: Output[String] = output.flatMap(_.diskSpaceStep)
      def diskSpaceUsed: Output[String] = output.flatMap(_.diskSpaceUsed)
      def maintenanceWindowDow: Output[Option[String]] = output.flatMap(_.maintenanceWindowDow)
      def maintenanceWindowTime: Output[Option[String]] = output.flatMap(_.maintenanceWindowTime)
      def mysqlUserConfig: Output[Option[besom.api.aiven.outputs.MySqlMysqlUserConfig]] = output.flatMap(_.mysqlUserConfig)
      def mysqls: Output[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlMysql]] = output.flatMap(_.mysqls)
      def plan: Output[String] = output.flatMap(_.plan)
      def project: Output[String] = output.flatMap(_.project)
      def projectVpcId: Output[Option[String]] = output.flatMap(_.projectVpcId)
      def serviceHost: Output[String] = output.flatMap(_.serviceHost)
      def serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlServiceIntegration]]] = output.flatMap(_.serviceIntegrations)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def servicePassword: Output[String] = output.flatMap(_.servicePassword)
      def servicePort: Output[Int] = output.flatMap(_.servicePort)
      def serviceType: Output[String] = output.flatMap(_.serviceType)
      def serviceUri: Output[String] = output.flatMap(_.serviceUri)
      def serviceUsername: Output[String] = output.flatMap(_.serviceUsername)
      def state: Output[String] = output.flatMap(_.state)
      def staticIps: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.staticIps)
      def tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.MySqlTag]]] = output.flatMap(_.tags)
      def terminationProtection: Output[Option[Boolean]] = output.flatMap(_.terminationProtection)

def mySql(using ctx: Context)(
  name: NonEmptyString,
  args: MySqlArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[MySql] = 
  ctx.registerResource[MySql, MySqlArgs]("aiven:index/mySql:MySql", name, args, opts)

