package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class MySqlArgs private(
  additionalDiskSpace: Output[Option[String]],
  cloudName: Output[Option[String]],
  diskSpace: Output[Option[String]],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  mysqlUserConfig: Output[Option[besom.api.aiven.inputs.MySqlMysqlUserConfigArgs]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.MySqlServiceIntegrationArgs]]],
  serviceName: Output[String],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.MySqlTagArgs]]],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object MySqlArgs:
  def apply(
    additionalDiskSpace: Input.Optional[String] = None,
    cloudName: Input.Optional[String] = None,
    diskSpace: Input.Optional[String] = None,
    maintenanceWindowDow: Input.Optional[String] = None,
    maintenanceWindowTime: Input.Optional[String] = None,
    mysqlUserConfig: Input.Optional[besom.api.aiven.inputs.MySqlMysqlUserConfigArgs] = None,
    plan: Input[String],
    project: Input[String],
    projectVpcId: Input.Optional[String] = None,
    serviceIntegrations: Input.Optional[List[Input[besom.api.aiven.inputs.MySqlServiceIntegrationArgs]]] = None,
    serviceName: Input[String],
    staticIps: Input.Optional[List[Input[String]]] = None,
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.MySqlTagArgs]]] = None,
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): MySqlArgs =
    new MySqlArgs(
      additionalDiskSpace = additionalDiskSpace.asOptionOutput(isSecret = false),
      cloudName = cloudName.asOptionOutput(isSecret = false),
      diskSpace = diskSpace.asOptionOutput(isSecret = false),
      maintenanceWindowDow = maintenanceWindowDow.asOptionOutput(isSecret = false),
      maintenanceWindowTime = maintenanceWindowTime.asOptionOutput(isSecret = false),
      mysqlUserConfig = mysqlUserConfig.asOptionOutput(isSecret = false),
      plan = plan.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      projectVpcId = projectVpcId.asOptionOutput(isSecret = false),
      serviceIntegrations = serviceIntegrations.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
