package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class MysqlUserArgs private(
  authentication: Output[Option[String]],
  password: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String],
  username: Output[String]
) derives ArgsEncoder

object MysqlUserArgs:
  def apply(
    authentication: Input.Optional[String] = None,
    password: Input.Optional[String] = None,
    project: Input[String],
    serviceName: Input[String],
    username: Input[String]
  )(using Context): MysqlUserArgs =
    new MysqlUserArgs(
      authentication = authentication.asOptionOutput(isSecret = false),
      password = password.asOptionOutput(isSecret = true),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      username = username.asOutput(isSecret = false)
    )
