package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class OpenSearch private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  additionalDiskSpace: Output[Option[String]],
  cloudName: Output[Option[String]],
  components: Output[scala.collection.immutable.List[besom.api.aiven.outputs.OpenSearchComponent]],
  diskSpace: Output[Option[String]],
  diskSpaceCap: Output[String],
  diskSpaceDefault: Output[String],
  diskSpaceStep: Output[String],
  diskSpaceUsed: Output[String],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  opensearchUserConfig: Output[Option[besom.api.aiven.outputs.OpenSearchOpensearchUserConfig]],
  opensearches: Output[scala.collection.immutable.List[besom.api.aiven.outputs.OpenSearchOpensearch]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceHost: Output[String],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.OpenSearchServiceIntegration]]],
  serviceName: Output[String],
  servicePassword: Output[String],
  servicePort: Output[Int],
  serviceType: Output[String],
  serviceUri: Output[String],
  serviceUsername: Output[String],
  state: Output[String],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.OpenSearchTag]]],
  terminationProtection: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object OpenSearch:
  given outputOps: {} with
    extension(output: Output[OpenSearch])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def additionalDiskSpace: Output[Option[String]] = output.flatMap(_.additionalDiskSpace)
      def cloudName: Output[Option[String]] = output.flatMap(_.cloudName)
      def components: Output[scala.collection.immutable.List[besom.api.aiven.outputs.OpenSearchComponent]] = output.flatMap(_.components)
      def diskSpace: Output[Option[String]] = output.flatMap(_.diskSpace)
      def diskSpaceCap: Output[String] = output.flatMap(_.diskSpaceCap)
      def diskSpaceDefault: Output[String] = output.flatMap(_.diskSpaceDefault)
      def diskSpaceStep: Output[String] = output.flatMap(_.diskSpaceStep)
      def diskSpaceUsed: Output[String] = output.flatMap(_.diskSpaceUsed)
      def maintenanceWindowDow: Output[Option[String]] = output.flatMap(_.maintenanceWindowDow)
      def maintenanceWindowTime: Output[Option[String]] = output.flatMap(_.maintenanceWindowTime)
      def opensearchUserConfig: Output[Option[besom.api.aiven.outputs.OpenSearchOpensearchUserConfig]] = output.flatMap(_.opensearchUserConfig)
      def opensearches: Output[scala.collection.immutable.List[besom.api.aiven.outputs.OpenSearchOpensearch]] = output.flatMap(_.opensearches)
      def plan: Output[String] = output.flatMap(_.plan)
      def project: Output[String] = output.flatMap(_.project)
      def projectVpcId: Output[Option[String]] = output.flatMap(_.projectVpcId)
      def serviceHost: Output[String] = output.flatMap(_.serviceHost)
      def serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.OpenSearchServiceIntegration]]] = output.flatMap(_.serviceIntegrations)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def servicePassword: Output[String] = output.flatMap(_.servicePassword)
      def servicePort: Output[Int] = output.flatMap(_.servicePort)
      def serviceType: Output[String] = output.flatMap(_.serviceType)
      def serviceUri: Output[String] = output.flatMap(_.serviceUri)
      def serviceUsername: Output[String] = output.flatMap(_.serviceUsername)
      def state: Output[String] = output.flatMap(_.state)
      def staticIps: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.staticIps)
      def tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.OpenSearchTag]]] = output.flatMap(_.tags)
      def terminationProtection: Output[Option[Boolean]] = output.flatMap(_.terminationProtection)

def openSearch(using ctx: Context)(
  name: NonEmptyString,
  args: OpenSearchArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[OpenSearch] = 
  ctx.registerResource[OpenSearch, OpenSearchArgs]("aiven:index/openSearch:OpenSearch", name, args, opts)

