package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class OpenSearchAclConfig private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  enabled: Output[Option[Boolean]],
  extendedAcl: Output[Option[Boolean]],
  project: Output[String],
  serviceName: Output[String]
) extends CustomResource derives ResourceDecoder

object OpenSearchAclConfig:
  given outputOps: {} with
    extension(output: Output[OpenSearchAclConfig])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def enabled: Output[Option[Boolean]] = output.flatMap(_.enabled)
      def extendedAcl: Output[Option[Boolean]] = output.flatMap(_.extendedAcl)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)

def openSearchAclConfig(using ctx: Context)(
  name: NonEmptyString,
  args: OpenSearchAclConfigArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[OpenSearchAclConfig] = 
  ctx.registerResource[OpenSearchAclConfig, OpenSearchAclConfigArgs]("aiven:index/openSearchAclConfig:OpenSearchAclConfig", name, args, opts)

