package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class OpenSearchAclConfigArgs private(
  enabled: Output[Option[Boolean]],
  extendedAcl: Output[Option[Boolean]],
  project: Output[String],
  serviceName: Output[String]
) derives ArgsEncoder

object OpenSearchAclConfigArgs:
  def apply(
    enabled: Input.Optional[Boolean] = None,
    extendedAcl: Input.Optional[Boolean] = None,
    project: Input[String],
    serviceName: Input[String]
  )(using Context): OpenSearchAclConfigArgs =
    new OpenSearchAclConfigArgs(
      enabled = enabled.asOptionOutput(isSecret = false),
      extendedAcl = extendedAcl.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false)
    )
