package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class OpenSearchAclRule private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  index: Output[String],
  permission: Output[String],
  project: Output[String],
  serviceName: Output[String],
  username: Output[String]
) extends CustomResource derives ResourceDecoder

object OpenSearchAclRule:
  given outputOps: {} with
    extension(output: Output[OpenSearchAclRule])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def index: Output[String] = output.flatMap(_.index)
      def permission: Output[String] = output.flatMap(_.permission)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def username: Output[String] = output.flatMap(_.username)

def openSearchAclRule(using ctx: Context)(
  name: NonEmptyString,
  args: OpenSearchAclRuleArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[OpenSearchAclRule] = 
  ctx.registerResource[OpenSearchAclRule, OpenSearchAclRuleArgs]("aiven:index/openSearchAclRule:OpenSearchAclRule", name, args, opts)

