package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class OpenSearchAclRuleArgs private(
  index: Output[String],
  permission: Output[String],
  project: Output[String],
  serviceName: Output[String],
  username: Output[String]
) derives ArgsEncoder

object OpenSearchAclRuleArgs:
  def apply(
    index: Input[String],
    permission: Input[String],
    project: Input[String],
    serviceName: Input[String],
    username: Input[String]
  )(using Context): OpenSearchAclRuleArgs =
    new OpenSearchAclRuleArgs(
      index = index.asOutput(isSecret = false),
      permission = permission.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      username = username.asOutput(isSecret = false)
    )
