package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Organization private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  createTime: Output[String],
  name: Output[String],
  tenantId: Output[String],
  timeouts: Output[Option[besom.api.aiven.outputs.OrganizationTimeouts]],
  updateTime: Output[String]
) extends CustomResource derives ResourceDecoder

object Organization:
  given outputOps: {} with
    extension(output: Output[Organization])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def createTime: Output[String] = output.flatMap(_.createTime)
      def name: Output[String] = output.flatMap(_.name)
      def tenantId: Output[String] = output.flatMap(_.tenantId)
      def timeouts: Output[Option[besom.api.aiven.outputs.OrganizationTimeouts]] = output.flatMap(_.timeouts)
      def updateTime: Output[String] = output.flatMap(_.updateTime)

def organization(using ctx: Context)(
  name: NonEmptyString,
  args: OrganizationArgs = OrganizationArgs(),
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Organization] = 
  ctx.registerResource[Organization, OrganizationArgs]("aiven:index/organization:Organization", name, args, opts)

