package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class OrganizationArgs private(
  name: Output[Option[String]],
  timeouts: Output[Option[besom.api.aiven.inputs.OrganizationTimeoutsArgs]]
) derives ArgsEncoder

object OrganizationArgs:
  def apply(
    name: Input.Optional[String] = None,
    timeouts: Input.Optional[besom.api.aiven.inputs.OrganizationTimeoutsArgs] = None
  )(using Context): OrganizationArgs =
    new OrganizationArgs(
      name = name.asOptionOutput(isSecret = false),
      timeouts = timeouts.asOptionOutput(isSecret = false)
    )
