package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class OrganizationUser private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accepted: Output[Boolean],
  createTime: Output[String],
  invitedBy: Output[String],
  organizationId: Output[String],
  userEmail: Output[String]
) extends CustomResource derives ResourceDecoder

object OrganizationUser:
  given outputOps: {} with
    extension(output: Output[OrganizationUser])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accepted: Output[Boolean] = output.flatMap(_.accepted)
      def createTime: Output[String] = output.flatMap(_.createTime)
      def invitedBy: Output[String] = output.flatMap(_.invitedBy)
      def organizationId: Output[String] = output.flatMap(_.organizationId)
      def userEmail: Output[String] = output.flatMap(_.userEmail)

def organizationUser(using ctx: Context)(
  name: NonEmptyString,
  args: OrganizationUserArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[OrganizationUser] = 
  ctx.registerResource[OrganizationUser, OrganizationUserArgs]("aiven:index/organizationUser:OrganizationUser", name, args, opts)

