package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class OrganizationUserArgs private(
  organizationId: Output[String],
  userEmail: Output[String]
) derives ArgsEncoder

object OrganizationUserArgs:
  def apply(
    organizationId: Input[String],
    userEmail: Input[String]
  )(using Context): OrganizationUserArgs =
    new OrganizationUserArgs(
      organizationId = organizationId.asOutput(isSecret = false),
      userEmail = userEmail.asOutput(isSecret = false)
    )
