package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class OrganizationUserGroup private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  createTime: Output[String],
  description: Output[Option[String]],
  name: Output[String],
  organizationId: Output[String],
  updateTime: Output[String]
) extends CustomResource derives ResourceDecoder

object OrganizationUserGroup:
  given outputOps: {} with
    extension(output: Output[OrganizationUserGroup])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def createTime: Output[String] = output.flatMap(_.createTime)
      def description: Output[Option[String]] = output.flatMap(_.description)
      def name: Output[String] = output.flatMap(_.name)
      def organizationId: Output[String] = output.flatMap(_.organizationId)
      def updateTime: Output[String] = output.flatMap(_.updateTime)

def organizationUserGroup(using ctx: Context)(
  name: NonEmptyString,
  args: OrganizationUserGroupArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[OrganizationUserGroup] = 
  ctx.registerResource[OrganizationUserGroup, OrganizationUserGroupArgs]("aiven:index/organizationUserGroup:OrganizationUserGroup", name, args, opts)

