package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class OrganizationUserGroupArgs private(
  description: Output[Option[String]],
  name: Output[Option[String]],
  organizationId: Output[String]
) derives ArgsEncoder

object OrganizationUserGroupArgs:
  def apply(
    description: Input.Optional[String] = None,
    name: Input.Optional[String] = None,
    organizationId: Input[String]
  )(using Context): OrganizationUserGroupArgs =
    new OrganizationUserGroupArgs(
      description = description.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      organizationId = organizationId.asOutput(isSecret = false)
    )
