package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class OrganizationalUnit private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  createTime: Output[String],
  name: Output[String],
  parentId: Output[String],
  tenantId: Output[String],
  updateTime: Output[String]
) extends CustomResource derives ResourceDecoder

object OrganizationalUnit:
  given outputOps: {} with
    extension(output: Output[OrganizationalUnit])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def createTime: Output[String] = output.flatMap(_.createTime)
      def name: Output[String] = output.flatMap(_.name)
      def parentId: Output[String] = output.flatMap(_.parentId)
      def tenantId: Output[String] = output.flatMap(_.tenantId)
      def updateTime: Output[String] = output.flatMap(_.updateTime)

def organizationalUnit(using ctx: Context)(
  name: NonEmptyString,
  args: OrganizationalUnitArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[OrganizationalUnit] = 
  ctx.registerResource[OrganizationalUnit, OrganizationalUnitArgs]("aiven:index/organizationalUnit:OrganizationalUnit", name, args, opts)

