package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class OrganizationalUnitArgs private(
  name: Output[Option[String]],
  parentId: Output[String]
) derives ArgsEncoder

object OrganizationalUnitArgs:
  def apply(
    name: Input.Optional[String] = None,
    parentId: Input[String]
  )(using Context): OrganizationalUnitArgs =
    new OrganizationalUnitArgs(
      name = name.asOptionOutput(isSecret = false),
      parentId = parentId.asOutput(isSecret = false)
    )
