package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class PgArgs private(
  additionalDiskSpace: Output[Option[String]],
  cloudName: Output[Option[String]],
  diskSpace: Output[Option[String]],
  maintenanceWindowDow: Output[Option[String]],
  maintenanceWindowTime: Output[Option[String]],
  pg: Output[Option[besom.api.aiven.inputs.PgPgArgs]],
  pgUserConfig: Output[Option[besom.api.aiven.inputs.PgPgUserConfigArgs]],
  plan: Output[String],
  project: Output[String],
  projectVpcId: Output[Option[String]],
  serviceIntegrations: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.PgServiceIntegrationArgs]]],
  serviceName: Output[Option[String]],
  staticIps: Output[Option[scala.collection.immutable.List[String]]],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.PgTagArgs]]],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object PgArgs:
  def apply(
    additionalDiskSpace: Input.Optional[String] = None,
    cloudName: Input.Optional[String] = None,
    diskSpace: Input.Optional[String] = None,
    maintenanceWindowDow: Input.Optional[String] = None,
    maintenanceWindowTime: Input.Optional[String] = None,
    pg: Input.Optional[besom.api.aiven.inputs.PgPgArgs] = None,
    pgUserConfig: Input.Optional[besom.api.aiven.inputs.PgPgUserConfigArgs] = None,
    plan: Input[String],
    project: Input[String],
    projectVpcId: Input.Optional[String] = None,
    serviceIntegrations: Input.Optional[List[Input[besom.api.aiven.inputs.PgServiceIntegrationArgs]]] = None,
    serviceName: Input.Optional[String] = None,
    staticIps: Input.Optional[List[Input[String]]] = None,
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.PgTagArgs]]] = None,
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): PgArgs =
    new PgArgs(
      additionalDiskSpace = additionalDiskSpace.asOptionOutput(isSecret = false),
      cloudName = cloudName.asOptionOutput(isSecret = false),
      diskSpace = diskSpace.asOptionOutput(isSecret = false),
      maintenanceWindowDow = maintenanceWindowDow.asOptionOutput(isSecret = false),
      maintenanceWindowTime = maintenanceWindowTime.asOptionOutput(isSecret = false),
      pg = pg.asOptionOutput(isSecret = false),
      pgUserConfig = pgUserConfig.asOptionOutput(isSecret = false),
      plan = plan.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      projectVpcId = projectVpcId.asOptionOutput(isSecret = false),
      serviceIntegrations = serviceIntegrations.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
