package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class PgDatabase private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  databaseName: Output[String],
  lcCollate: Output[Option[String]],
  lcCtype: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String],
  terminationProtection: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object PgDatabase:
  given outputOps: {} with
    extension(output: Output[PgDatabase])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def databaseName: Output[String] = output.flatMap(_.databaseName)
      def lcCollate: Output[Option[String]] = output.flatMap(_.lcCollate)
      def lcCtype: Output[Option[String]] = output.flatMap(_.lcCtype)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def terminationProtection: Output[Option[Boolean]] = output.flatMap(_.terminationProtection)

def pgDatabase(using ctx: Context)(
  name: NonEmptyString,
  args: PgDatabaseArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[PgDatabase] = 
  ctx.registerResource[PgDatabase, PgDatabaseArgs]("aiven:index/pgDatabase:PgDatabase", name, args, opts)

