package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class PgDatabaseArgs private(
  databaseName: Output[String],
  lcCollate: Output[Option[String]],
  lcCtype: Output[Option[String]],
  project: Output[String],
  serviceName: Output[String],
  terminationProtection: Output[Option[Boolean]]
) derives ArgsEncoder

object PgDatabaseArgs:
  def apply(
    databaseName: Input[String],
    lcCollate: Input.Optional[String] = None,
    lcCtype: Input.Optional[String] = None,
    project: Input[String],
    serviceName: Input[String],
    terminationProtection: Input.Optional[Boolean] = None
  )(using Context): PgDatabaseArgs =
    new PgDatabaseArgs(
      databaseName = databaseName.asOutput(isSecret = false),
      lcCollate = lcCollate.asOptionOutput(isSecret = false),
      lcCtype = lcCtype.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      terminationProtection = terminationProtection.asOptionOutput(isSecret = false)
    )
