package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class PgUser private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accessCert: Output[String],
  accessKey: Output[String],
  password: Output[String],
  pgAllowReplication: Output[Option[Boolean]],
  project: Output[String],
  serviceName: Output[String],
  `type`: Output[String],
  username: Output[String]
) extends CustomResource derives ResourceDecoder

object PgUser:
  given outputOps: {} with
    extension(output: Output[PgUser])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accessCert: Output[String] = output.flatMap(_.accessCert)
      def accessKey: Output[String] = output.flatMap(_.accessKey)
      def password: Output[String] = output.flatMap(_.password)
      def pgAllowReplication: Output[Option[Boolean]] = output.flatMap(_.pgAllowReplication)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def username: Output[String] = output.flatMap(_.username)

def pgUser(using ctx: Context)(
  name: NonEmptyString,
  args: PgUserArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[PgUser] = 
  ctx.registerResource[PgUser, PgUserArgs]("aiven:index/pgUser:PgUser", name, args, opts)

