package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class PgUserArgs private(
  password: Output[Option[String]],
  pgAllowReplication: Output[Option[Boolean]],
  project: Output[String],
  serviceName: Output[String],
  username: Output[String]
) derives ArgsEncoder

object PgUserArgs:
  def apply(
    password: Input.Optional[String] = None,
    pgAllowReplication: Input.Optional[Boolean] = None,
    project: Input[String],
    serviceName: Input[String],
    username: Input[String]
  )(using Context): PgUserArgs =
    new PgUserArgs(
      password = password.asOptionOutput(isSecret = true),
      pgAllowReplication = pgAllowReplication.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      username = username.asOutput(isSecret = false)
    )
