package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class Project private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accountId: Output[Option[String]],
  addAccountOwnersAdminAccess: Output[Option[Boolean]],
  availableCredits: Output[String],
  billingGroup: Output[Option[String]],
  caCert: Output[String],
  copyFromProject: Output[Option[String]],
  defaultCloud: Output[Option[String]],
  estimatedBalance: Output[String],
  parentId: Output[Option[String]],
  paymentMethod: Output[String],
  project: Output[String],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.ProjectTag]]],
  technicalEmails: Output[Option[scala.collection.immutable.List[String]]],
  useSourceProjectBillingGroup: Output[Option[Boolean]]
) extends CustomResource derives ResourceDecoder

object Project:
  given outputOps: {} with
    extension(output: Output[Project])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accountId: Output[Option[String]] = output.flatMap(_.accountId)
      def addAccountOwnersAdminAccess: Output[Option[Boolean]] = output.flatMap(_.addAccountOwnersAdminAccess)
      def availableCredits: Output[String] = output.flatMap(_.availableCredits)
      def billingGroup: Output[Option[String]] = output.flatMap(_.billingGroup)
      def caCert: Output[String] = output.flatMap(_.caCert)
      def copyFromProject: Output[Option[String]] = output.flatMap(_.copyFromProject)
      def defaultCloud: Output[Option[String]] = output.flatMap(_.defaultCloud)
      def estimatedBalance: Output[String] = output.flatMap(_.estimatedBalance)
      def parentId: Output[Option[String]] = output.flatMap(_.parentId)
      def paymentMethod: Output[String] = output.flatMap(_.paymentMethod)
      def project: Output[String] = output.flatMap(_.project)
      def tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.outputs.ProjectTag]]] = output.flatMap(_.tags)
      def technicalEmails: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.technicalEmails)
      def useSourceProjectBillingGroup: Output[Option[Boolean]] = output.flatMap(_.useSourceProjectBillingGroup)

def project(using ctx: Context)(
  name: NonEmptyString,
  args: ProjectArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[Project] = 
  ctx.registerResource[Project, ProjectArgs]("aiven:index/project:Project", name, args, opts)

