package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ProjectArgs private(
  accountId: Output[Option[String]],
  addAccountOwnersAdminAccess: Output[Option[Boolean]],
  billingGroup: Output[Option[String]],
  copyFromProject: Output[Option[String]],
  defaultCloud: Output[Option[String]],
  parentId: Output[Option[String]],
  project: Output[String],
  tags: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.ProjectTagArgs]]],
  technicalEmails: Output[Option[scala.collection.immutable.List[String]]],
  useSourceProjectBillingGroup: Output[Option[Boolean]]
) derives ArgsEncoder

object ProjectArgs:
  def apply(
    accountId: Input.Optional[String] = None,
    addAccountOwnersAdminAccess: Input.Optional[Boolean] = None,
    billingGroup: Input.Optional[String] = None,
    copyFromProject: Input.Optional[String] = None,
    defaultCloud: Input.Optional[String] = None,
    parentId: Input.Optional[String] = None,
    project: Input[String],
    tags: Input.Optional[List[Input[besom.api.aiven.inputs.ProjectTagArgs]]] = None,
    technicalEmails: Input.Optional[List[Input[String]]] = None,
    useSourceProjectBillingGroup: Input.Optional[Boolean] = None
  )(using Context): ProjectArgs =
    new ProjectArgs(
      accountId = accountId.asOptionOutput(isSecret = false),
      addAccountOwnersAdminAccess = addAccountOwnersAdminAccess.asOptionOutput(isSecret = false),
      billingGroup = billingGroup.asOptionOutput(isSecret = false),
      copyFromProject = copyFromProject.asOptionOutput(isSecret = false),
      defaultCloud = defaultCloud.asOptionOutput(isSecret = false),
      parentId = parentId.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      tags = tags.asOptionOutput(isSecret = false),
      technicalEmails = technicalEmails.asOptionOutput(isSecret = false),
      useSourceProjectBillingGroup = useSourceProjectBillingGroup.asOptionOutput(isSecret = false)
    )
