package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ProjectUser private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  accepted: Output[Boolean],
  email: Output[String],
  memberType: Output[String],
  project: Output[String]
) extends CustomResource derives ResourceDecoder

object ProjectUser:
  given outputOps: {} with
    extension(output: Output[ProjectUser])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def accepted: Output[Boolean] = output.flatMap(_.accepted)
      def email: Output[String] = output.flatMap(_.email)
      def memberType: Output[String] = output.flatMap(_.memberType)
      def project: Output[String] = output.flatMap(_.project)

def projectUser(using ctx: Context)(
  name: NonEmptyString,
  args: ProjectUserArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ProjectUser] = 
  ctx.registerResource[ProjectUser, ProjectUserArgs]("aiven:index/projectUser:ProjectUser", name, args, opts)

