package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ProjectUserArgs private(
  email: Output[String],
  memberType: Output[String],
  project: Output[String]
) derives ArgsEncoder

object ProjectUserArgs:
  def apply(
    email: Input[String],
    memberType: Input[String],
    project: Input[String]
  )(using Context): ProjectUserArgs =
    new ProjectUserArgs(
      email = email.asOutput(isSecret = false),
      memberType = memberType.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false)
    )
