package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ProjectVpc private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  cloudName: Output[String],
  networkCidr: Output[String],
  project: Output[String],
  state: Output[String]
) extends CustomResource derives ResourceDecoder

object ProjectVpc:
  given outputOps: {} with
    extension(output: Output[ProjectVpc])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def cloudName: Output[String] = output.flatMap(_.cloudName)
      def networkCidr: Output[String] = output.flatMap(_.networkCidr)
      def project: Output[String] = output.flatMap(_.project)
      def state: Output[String] = output.flatMap(_.state)

def projectVpc(using ctx: Context)(
  name: NonEmptyString,
  args: ProjectVpcArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ProjectVpc] = 
  ctx.registerResource[ProjectVpc, ProjectVpcArgs]("aiven:index/projectVpc:ProjectVpc", name, args, opts)

