package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ProjectVpcArgs private(
  cloudName: Output[String],
  networkCidr: Output[String],
  project: Output[String]
) derives ArgsEncoder

object ProjectVpcArgs:
  def apply(
    cloudName: Input[String],
    networkCidr: Input[String],
    project: Input[String]
  )(using Context): ProjectVpcArgs =
    new ProjectVpcArgs(
      cloudName = cloudName.asOutput(isSecret = false),
      networkCidr = networkCidr.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false)
    )
