package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ProviderArgsEncoder

final case class ProviderArgs private(
  apiToken: Output[Option[String]]
) derives ProviderArgsEncoder

object ProviderArgs:
  def apply(
    apiToken: Input.Optional[String] = None
  )(using Context): ProviderArgs =
    new ProviderArgs(
      apiToken = apiToken.asOptionOutput(isSecret = true)
    )
