package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class RedisUser private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  password: Output[String],
  project: Output[String],
  redisAclCategories: Output[Option[scala.collection.immutable.List[String]]],
  redisAclChannels: Output[Option[scala.collection.immutable.List[String]]],
  redisAclCommands: Output[Option[scala.collection.immutable.List[String]]],
  redisAclKeys: Output[Option[scala.collection.immutable.List[String]]],
  serviceName: Output[String],
  `type`: Output[String],
  username: Output[String]
) extends CustomResource derives ResourceDecoder

object RedisUser:
  given outputOps: {} with
    extension(output: Output[RedisUser])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def password: Output[String] = output.flatMap(_.password)
      def project: Output[String] = output.flatMap(_.project)
      def redisAclCategories: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.redisAclCategories)
      def redisAclChannels: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.redisAclChannels)
      def redisAclCommands: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.redisAclCommands)
      def redisAclKeys: Output[Option[scala.collection.immutable.List[String]]] = output.flatMap(_.redisAclKeys)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def `type`: Output[String] = output.flatMap(_.`type`)
      def username: Output[String] = output.flatMap(_.username)

def redisUser(using ctx: Context)(
  name: NonEmptyString,
  args: RedisUserArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[RedisUser] = 
  ctx.registerResource[RedisUser, RedisUserArgs]("aiven:index/redisUser:RedisUser", name, args, opts)

