package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class RedisUserArgs private(
  password: Output[Option[String]],
  project: Output[String],
  redisAclCategories: Output[Option[scala.collection.immutable.List[String]]],
  redisAclChannels: Output[Option[scala.collection.immutable.List[String]]],
  redisAclCommands: Output[Option[scala.collection.immutable.List[String]]],
  redisAclKeys: Output[Option[scala.collection.immutable.List[String]]],
  serviceName: Output[String],
  username: Output[String]
) derives ArgsEncoder

object RedisUserArgs:
  def apply(
    password: Input.Optional[String] = None,
    project: Input[String],
    redisAclCategories: Input.Optional[List[Input[String]]] = None,
    redisAclChannels: Input.Optional[List[Input[String]]] = None,
    redisAclCommands: Input.Optional[List[Input[String]]] = None,
    redisAclKeys: Input.Optional[List[Input[String]]] = None,
    serviceName: Input[String],
    username: Input[String]
  )(using Context): RedisUserArgs =
    new RedisUserArgs(
      password = password.asOptionOutput(isSecret = true),
      project = project.asOutput(isSecret = false),
      redisAclCategories = redisAclCategories.asOptionOutput(isSecret = false),
      redisAclChannels = redisAclChannels.asOptionOutput(isSecret = false),
      redisAclCommands = redisAclCommands.asOptionOutput(isSecret = false),
      redisAclKeys = redisAclKeys.asOptionOutput(isSecret = false),
      serviceName = serviceName.asOutput(isSecret = false),
      username = username.asOutput(isSecret = false)
    )
