package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ServiceIntegration private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  clickhouseKafkaUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationClickhouseKafkaUserConfig]],
  clickhousePostgresqlUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationClickhousePostgresqlUserConfig]],
  datadogUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfig]],
  destinationEndpointId: Output[Option[String]],
  destinationServiceName: Output[Option[String]],
  externalAwsCloudwatchMetricsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationExternalAwsCloudwatchMetricsUserConfig]],
  integrationId: Output[String],
  integrationType: Output[String],
  kafkaConnectUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationKafkaConnectUserConfig]],
  kafkaLogsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationKafkaLogsUserConfig]],
  kafkaMirrormakerUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationKafkaMirrormakerUserConfig]],
  logsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationLogsUserConfig]],
  metricsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationMetricsUserConfig]],
  project: Output[String],
  sourceEndpointId: Output[Option[String]],
  sourceServiceName: Output[Option[String]]
) extends CustomResource derives ResourceDecoder

object ServiceIntegration:
  given outputOps: {} with
    extension(output: Output[ServiceIntegration])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def clickhouseKafkaUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationClickhouseKafkaUserConfig]] = output.flatMap(_.clickhouseKafkaUserConfig)
      def clickhousePostgresqlUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationClickhousePostgresqlUserConfig]] = output.flatMap(_.clickhousePostgresqlUserConfig)
      def datadogUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationDatadogUserConfig]] = output.flatMap(_.datadogUserConfig)
      def destinationEndpointId: Output[Option[String]] = output.flatMap(_.destinationEndpointId)
      def destinationServiceName: Output[Option[String]] = output.flatMap(_.destinationServiceName)
      def externalAwsCloudwatchMetricsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationExternalAwsCloudwatchMetricsUserConfig]] = output.flatMap(_.externalAwsCloudwatchMetricsUserConfig)
      def integrationId: Output[String] = output.flatMap(_.integrationId)
      def integrationType: Output[String] = output.flatMap(_.integrationType)
      def kafkaConnectUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationKafkaConnectUserConfig]] = output.flatMap(_.kafkaConnectUserConfig)
      def kafkaLogsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationKafkaLogsUserConfig]] = output.flatMap(_.kafkaLogsUserConfig)
      def kafkaMirrormakerUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationKafkaMirrormakerUserConfig]] = output.flatMap(_.kafkaMirrormakerUserConfig)
      def logsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationLogsUserConfig]] = output.flatMap(_.logsUserConfig)
      def metricsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationMetricsUserConfig]] = output.flatMap(_.metricsUserConfig)
      def project: Output[String] = output.flatMap(_.project)
      def sourceEndpointId: Output[Option[String]] = output.flatMap(_.sourceEndpointId)
      def sourceServiceName: Output[Option[String]] = output.flatMap(_.sourceServiceName)

def serviceIntegration(using ctx: Context)(
  name: NonEmptyString,
  args: ServiceIntegrationArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ServiceIntegration] = 
  ctx.registerResource[ServiceIntegration, ServiceIntegrationArgs]("aiven:index/serviceIntegration:ServiceIntegration", name, args, opts)

