package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ServiceIntegrationArgs private(
  clickhouseKafkaUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationClickhouseKafkaUserConfigArgs]],
  clickhousePostgresqlUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationClickhousePostgresqlUserConfigArgs]],
  datadogUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationDatadogUserConfigArgs]],
  destinationEndpointId: Output[Option[String]],
  destinationServiceName: Output[Option[String]],
  externalAwsCloudwatchMetricsUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs]],
  integrationType: Output[String],
  kafkaConnectUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationKafkaConnectUserConfigArgs]],
  kafkaLogsUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationKafkaLogsUserConfigArgs]],
  kafkaMirrormakerUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationKafkaMirrormakerUserConfigArgs]],
  logsUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationLogsUserConfigArgs]],
  metricsUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationMetricsUserConfigArgs]],
  project: Output[String],
  sourceEndpointId: Output[Option[String]],
  sourceServiceName: Output[Option[String]]
) derives ArgsEncoder

object ServiceIntegrationArgs:
  def apply(
    clickhouseKafkaUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationClickhouseKafkaUserConfigArgs] = None,
    clickhousePostgresqlUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationClickhousePostgresqlUserConfigArgs] = None,
    datadogUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationDatadogUserConfigArgs] = None,
    destinationEndpointId: Input.Optional[String] = None,
    destinationServiceName: Input.Optional[String] = None,
    externalAwsCloudwatchMetricsUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs] = None,
    integrationType: Input[String],
    kafkaConnectUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationKafkaConnectUserConfigArgs] = None,
    kafkaLogsUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationKafkaLogsUserConfigArgs] = None,
    kafkaMirrormakerUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationKafkaMirrormakerUserConfigArgs] = None,
    logsUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationLogsUserConfigArgs] = None,
    metricsUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationMetricsUserConfigArgs] = None,
    project: Input[String],
    sourceEndpointId: Input.Optional[String] = None,
    sourceServiceName: Input.Optional[String] = None
  )(using Context): ServiceIntegrationArgs =
    new ServiceIntegrationArgs(
      clickhouseKafkaUserConfig = clickhouseKafkaUserConfig.asOptionOutput(isSecret = false),
      clickhousePostgresqlUserConfig = clickhousePostgresqlUserConfig.asOptionOutput(isSecret = false),
      datadogUserConfig = datadogUserConfig.asOptionOutput(isSecret = false),
      destinationEndpointId = destinationEndpointId.asOptionOutput(isSecret = false),
      destinationServiceName = destinationServiceName.asOptionOutput(isSecret = false),
      externalAwsCloudwatchMetricsUserConfig = externalAwsCloudwatchMetricsUserConfig.asOptionOutput(isSecret = false),
      integrationType = integrationType.asOutput(isSecret = false),
      kafkaConnectUserConfig = kafkaConnectUserConfig.asOptionOutput(isSecret = false),
      kafkaLogsUserConfig = kafkaLogsUserConfig.asOptionOutput(isSecret = false),
      kafkaMirrormakerUserConfig = kafkaMirrormakerUserConfig.asOptionOutput(isSecret = false),
      logsUserConfig = logsUserConfig.asOptionOutput(isSecret = false),
      metricsUserConfig = metricsUserConfig.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      sourceEndpointId = sourceEndpointId.asOptionOutput(isSecret = false),
      sourceServiceName = sourceServiceName.asOptionOutput(isSecret = false)
    )
