package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class ServiceIntegrationEndpoint private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  datadogUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointDatadogUserConfig]],
  endpointConfig: Output[scala.Predef.Map[String, String]],
  endpointName: Output[String],
  endpointType: Output[String],
  externalAwsCloudwatchLogsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig]],
  externalAwsCloudwatchMetricsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfig]],
  externalElasticsearchLogsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig]],
  externalGoogleCloudLoggingUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig]],
  externalKafkaUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalKafkaUserConfig]],
  externalOpensearchLogsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalOpensearchLogsUserConfig]],
  externalSchemaRegistryUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalSchemaRegistryUserConfig]],
  jolokiaUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointJolokiaUserConfig]],
  project: Output[String],
  prometheusUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointPrometheusUserConfig]],
  rsyslogUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointRsyslogUserConfig]]
) extends CustomResource derives ResourceDecoder

object ServiceIntegrationEndpoint:
  given outputOps: {} with
    extension(output: Output[ServiceIntegrationEndpoint])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def datadogUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointDatadogUserConfig]] = output.flatMap(_.datadogUserConfig)
      def endpointConfig: Output[scala.Predef.Map[String, String]] = output.flatMap(_.endpointConfig)
      def endpointName: Output[String] = output.flatMap(_.endpointName)
      def endpointType: Output[String] = output.flatMap(_.endpointType)
      def externalAwsCloudwatchLogsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfig]] = output.flatMap(_.externalAwsCloudwatchLogsUserConfig)
      def externalAwsCloudwatchMetricsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfig]] = output.flatMap(_.externalAwsCloudwatchMetricsUserConfig)
      def externalElasticsearchLogsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalElasticsearchLogsUserConfig]] = output.flatMap(_.externalElasticsearchLogsUserConfig)
      def externalGoogleCloudLoggingUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfig]] = output.flatMap(_.externalGoogleCloudLoggingUserConfig)
      def externalKafkaUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalKafkaUserConfig]] = output.flatMap(_.externalKafkaUserConfig)
      def externalOpensearchLogsUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalOpensearchLogsUserConfig]] = output.flatMap(_.externalOpensearchLogsUserConfig)
      def externalSchemaRegistryUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointExternalSchemaRegistryUserConfig]] = output.flatMap(_.externalSchemaRegistryUserConfig)
      def jolokiaUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointJolokiaUserConfig]] = output.flatMap(_.jolokiaUserConfig)
      def project: Output[String] = output.flatMap(_.project)
      def prometheusUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointPrometheusUserConfig]] = output.flatMap(_.prometheusUserConfig)
      def rsyslogUserConfig: Output[Option[besom.api.aiven.outputs.ServiceIntegrationEndpointRsyslogUserConfig]] = output.flatMap(_.rsyslogUserConfig)

def serviceIntegrationEndpoint(using ctx: Context)(
  name: NonEmptyString,
  args: ServiceIntegrationEndpointArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[ServiceIntegrationEndpoint] = 
  ctx.registerResource[ServiceIntegrationEndpoint, ServiceIntegrationEndpointArgs]("aiven:index/serviceIntegrationEndpoint:ServiceIntegrationEndpoint", name, args, opts)

