package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class ServiceIntegrationEndpointArgs private(
  datadogUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointDatadogUserConfigArgs]],
  endpointName: Output[String],
  endpointType: Output[String],
  externalAwsCloudwatchLogsUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs]],
  externalAwsCloudwatchMetricsUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs]],
  externalElasticsearchLogsUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs]],
  externalGoogleCloudLoggingUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs]],
  externalKafkaUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalKafkaUserConfigArgs]],
  externalOpensearchLogsUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs]],
  externalSchemaRegistryUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs]],
  jolokiaUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointJolokiaUserConfigArgs]],
  project: Output[String],
  prometheusUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointPrometheusUserConfigArgs]],
  rsyslogUserConfig: Output[Option[besom.api.aiven.inputs.ServiceIntegrationEndpointRsyslogUserConfigArgs]]
) derives ArgsEncoder

object ServiceIntegrationEndpointArgs:
  def apply(
    datadogUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointDatadogUserConfigArgs] = None,
    endpointName: Input[String],
    endpointType: Input[String],
    externalAwsCloudwatchLogsUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigArgs] = None,
    externalAwsCloudwatchMetricsUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigArgs] = None,
    externalElasticsearchLogsUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalElasticsearchLogsUserConfigArgs] = None,
    externalGoogleCloudLoggingUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigArgs] = None,
    externalKafkaUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalKafkaUserConfigArgs] = None,
    externalOpensearchLogsUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalOpensearchLogsUserConfigArgs] = None,
    externalSchemaRegistryUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointExternalSchemaRegistryUserConfigArgs] = None,
    jolokiaUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointJolokiaUserConfigArgs] = None,
    project: Input[String],
    prometheusUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointPrometheusUserConfigArgs] = None,
    rsyslogUserConfig: Input.Optional[besom.api.aiven.inputs.ServiceIntegrationEndpointRsyslogUserConfigArgs] = None
  )(using Context): ServiceIntegrationEndpointArgs =
    new ServiceIntegrationEndpointArgs(
      datadogUserConfig = datadogUserConfig.asOptionOutput(isSecret = false),
      endpointName = endpointName.asOutput(isSecret = false),
      endpointType = endpointType.asOutput(isSecret = false),
      externalAwsCloudwatchLogsUserConfig = externalAwsCloudwatchLogsUserConfig.asOptionOutput(isSecret = false),
      externalAwsCloudwatchMetricsUserConfig = externalAwsCloudwatchMetricsUserConfig.asOptionOutput(isSecret = false),
      externalElasticsearchLogsUserConfig = externalElasticsearchLogsUserConfig.asOptionOutput(isSecret = false),
      externalGoogleCloudLoggingUserConfig = externalGoogleCloudLoggingUserConfig.asOptionOutput(isSecret = false),
      externalKafkaUserConfig = externalKafkaUserConfig.asOptionOutput(isSecret = false),
      externalOpensearchLogsUserConfig = externalOpensearchLogsUserConfig.asOptionOutput(isSecret = false),
      externalSchemaRegistryUserConfig = externalSchemaRegistryUserConfig.asOptionOutput(isSecret = false),
      jolokiaUserConfig = jolokiaUserConfig.asOptionOutput(isSecret = false),
      project = project.asOutput(isSecret = false),
      prometheusUserConfig = prometheusUserConfig.asOptionOutput(isSecret = false),
      rsyslogUserConfig = rsyslogUserConfig.asOptionOutput(isSecret = false)
    )
