package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class StaticIp private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  cloudName: Output[String],
  ipAddress: Output[String],
  project: Output[String],
  serviceName: Output[String],
  state: Output[String],
  staticIpAddressId: Output[String]
) extends CustomResource derives ResourceDecoder

object StaticIp:
  given outputOps: {} with
    extension(output: Output[StaticIp])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def cloudName: Output[String] = output.flatMap(_.cloudName)
      def ipAddress: Output[String] = output.flatMap(_.ipAddress)
      def project: Output[String] = output.flatMap(_.project)
      def serviceName: Output[String] = output.flatMap(_.serviceName)
      def state: Output[String] = output.flatMap(_.state)
      def staticIpAddressId: Output[String] = output.flatMap(_.staticIpAddressId)

def staticIp(using ctx: Context)(
  name: NonEmptyString,
  args: StaticIpArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[StaticIp] = 
  ctx.registerResource[StaticIp, StaticIpArgs]("aiven:index/staticIp:StaticIp", name, args, opts)

