package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class StaticIpArgs private(
  cloudName: Output[String],
  project: Output[String]
) derives ArgsEncoder

object StaticIpArgs:
  def apply(
    cloudName: Input[String],
    project: Input[String]
  )(using Context): StaticIpArgs =
    new StaticIpArgs(
      cloudName = cloudName.asOutput(isSecret = false),
      project = project.asOutput(isSecret = false)
    )
